//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "UnitCompile.h"
#include "UnitMain.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormCompile *FormCompile;




AnsiString __fastcall TFormCompile::ExtractName(AnsiString name)
{
	int pp,pd;

	pp=name.LastDelimiter("\\/")+1;
	pd=name.LastDelimiter(".");
	if(!pd) pd=name.Length()+1;

	return name.SubString(pp,pd-pp);
}



void __fastcall TFormCompile::CalcSize(void)
{
	Size=FormMain->CalcDataSize();
	if(CheckBoxPlayer->Checked) Size+=PlayerSize;
}



void __fastcall TFormCompile::UpdateAll(void)
{
	CalcSize();

	CheckBoxTest->Enabled=(RadioButtonTape->Checked&&CheckBoxPlayer->Checked)?true:false;

	EditAddress->Text=IntToStr(Address);
	EditSize->Text=IntToStr(Size);
}




//---------------------------------------------------------------------------
__fastcall TFormCompile::TFormCompile(TComponent* Owner)
: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormCompile::ButtonCancelClick(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
void __fastcall TFormCompile::ButtonCompileClick(TObject *Sender)
{
	AnsiString name;

	SaveDialogData->FileName=ExtractName(SaveDialogData->FileName);

	if(RadioButtonBinary->Checked)
	{
		if(!CheckBoxPlayer->Checked)
		{
			SaveDialogData->Filter="Binary file without player (*.bin)|*.bin|Any file (*.*)|*.*";
		}
		else
		{
			SaveDialogData->Filter="Binary file with player (*.bin)|*.bin|Any file (*.*)|*.*";
		}
	}

	if(RadioButtonAssembly->Checked)
	{
		if(!CheckBoxPlayer->Checked)
		{
			SaveDialogData->Filter="Assembly code without player (*.asm)|*.asm|Any file (*.*)|*.*";
		}
		else
		{
			SaveDialogData->Filter="Assembly code with player (*.asm)|*.asm|Any file (*.*)|*.*";
		}
	}

	if(RadioButtonTape->Checked)
	{
		if(!CheckBoxPlayer->Checked)
		{
			SaveDialogData->Filter="Tape file without player (*.tap)|*.tap|Any file (*.*)|*.*";
		}
		else
		{
			if(!CheckBoxTest->Checked)
			{
				SaveDialogData->Filter="Tape file with player (*.tap)|*.tap|Any file (*.*)|*.*";
			}
			else
			{
				SaveDialogData->Filter="Tape file with player and test (*.tap)|*.tap|Any file (*.*)|*.*";
			}
		}
	}

	if(SaveDialogData->Execute())
	{
		name=ExtractName(SaveDialogData->FileName);

		if(RadioButtonBinary->Checked)   name+=".bin";
		if(RadioButtonAssembly->Checked) name+=".asm";
		if(RadioButtonTape->Checked)     name+=".tap";

		if(FileExists(name))
		{
			if(Application->MessageBox("File exists, overwrite?","Confirm",MB_YESNO)==IDNO) return;
		}

		if(RadioButtonBinary->Checked)   FormMain->CompileBinary(name,Address,CheckBoxPlayer->Checked);
		if(RadioButtonAssembly->Checked) FormMain->CompileAssembly(name,Address,CheckBoxPlayer->Checked);
		if(RadioButtonTape->Checked)     FormMain->CompileTap(name,Address,CheckBoxPlayer->Checked,CheckBoxTest->Checked);

		Close();
	}
}
//---------------------------------------------------------------------------
void __fastcall TFormCompile::RadioButtonBinaryClick(TObject *Sender)
{
	UpdateAll();
}
//---------------------------------------------------------------------------
void __fastcall TFormCompile::EditAddressExit(TObject *Sender)
{
	CalcSize();

	Address=StrToIntDef(EditAddress->Text,32768);
	if(Address<32768) Address=32768;
	if(Address+Size>=65536) Address=65536-Size;

	UpdateAll();
}
//---------------------------------------------------------------------------

void __fastcall TFormCompile::FormShow(TObject *Sender)
{
	UpdateAll();
}
//---------------------------------------------------------------------------

void __fastcall TFormCompile::EditAddressKeyPress(TObject *Sender, char &Key)
{
	if(Key!=VK_BACK&&(Key<'0'||Key>'9')) Key=0;
}
//---------------------------------------------------------------------------

void __fastcall TFormCompile::FormCreate(TObject *Sender)
{
	Address=60000;
	Size=0;
}
//---------------------------------------------------------------------------

