//---------------------------------------------------------------------------

#include <vcl.h>
#include <stdio.h>
#include <math.h>

#pragma hdrstop

#include "UnitMain.h"
#include "UnitImportWav.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormImportWAV *FormImportWAV;



#define MAX_SAMPLE_SIZE		32000



unsigned short __fastcall TFormImportWAV::RdWordLH(unsigned char *bytes)
{
	return bytes[0]+(bytes[1]<<8);
}



unsigned int __fastcall TFormImportWAV::RdDWordLH(unsigned char *bytes)
{
	return bytes[0]+(bytes[1]<<8)+(bytes[2]<<16)+(bytes[3]<<24);
}



void __fastcall TFormImportWAV::Error(AnsiString str)
{
	Application->MessageBox(str.c_str(),"Error",MB_OK);
}



bool __fastcall TFormImportWAV::LoadWAV(AnsiString name)
{
	FILE *file;
	unsigned char *wave;
	int i,j,n,ptr,size,channels,bits,rate;
	bool found;

	file=fopen(name.c_str(),"rb");

	if(!file) return false;

	fseek(file,0,SEEK_END);
	size=ftell(file);

	if(size>=1024*1024*10)
	{
		Error("File is too big.");
		fclose(file);
		return false;
	}

	fseek(file,0,SEEK_SET);

	wave=(unsigned char*)malloc(size);

	memset(wave,0,size);

	if(!wave)
	{
		fclose(file);
		return false;
	}

	fread(wave,size,1,file);
	fclose(file);

	found=false;

	for(i=0;i<size-4;++i)
	{
		if(memcmp(&wave[i],"RIFF",4)==0)
		{
			found=true;
			ptr=i;
			break;
		}
	}

	if(!found)
	{
		Error("RIFF chunk is not found.");
		free(wave);
		return false;
	}

	found=false;

	for(i=ptr;i<size-4;++i)
	{
		if(!memcmp(&wave[i],"WAVEfmt ",8))
		{
			found=true;
			ptr=i;
			break;
		}
	}

	if(!found)
	{
		Error("WAVEfmt chunk is not found.");
		free(wave);
		return false;
	}

	if(RdWordLH(&wave[ptr+12])!=1)
	{
		Error("Only unpacked PCM is supported.");
		free(wave);
		return false;
	}

	channels=RdWordLH(&wave[ptr+14]);

	if(channels>2)
	{
		Error("Only mono and stereo files are supported.");
		free(wave);
		return false;
	}

	rate=RdDWordLH(&wave[ptr+16]);
	bits=RdWordLH(&wave[ptr+26]);

	if(bits!=8&&bits!=16)
	{
		Error("Only 8 and 16 bit PCM is supported.");
		free(wave);
		return false;
	}

	found=false;

	for(i=ptr+28;i<size-4;++i)
	{
		if(!memcmp(&wave[i],"data",4))
		{
			found=true;
			ptr=i;
			break;
		}
	}

	if(!found)
	{
		Error("DATA chunk is not found.");
		free(wave);
		return false;
	}

	size=RdDWordLH(&wave[ptr+4])/channels/(bits>>3);

	ptr+=8;

	if(SampleData) free(SampleData);

	SampleData=(short int*)malloc(size*sizeof(short int));
	SampleSize=size;
	SampleRate=rate;
	SampleStart=0;
	SampleEnd=1;
	SampleVolume=1;

	for(i=0;i<size;++i)
	{
		n=0;

		switch(bits)
		{
		case 8:
			for(j=0;j<channels;++j) n+=(wave[ptr++]<<8);

			break;

		case 16:
			for(j=0;j<channels;++j)
			{
				n+=(wave[ptr+0]+(wave[ptr+1]<<8));
				ptr+=2;
			}
			break;
		}

		SampleData[i]=n/channels;
	}

	free(wave);

	return true;
}



int __fastcall TFormImportWAV::CalcSampleSize(void)
{
	float n;

	n=(float)SampleSize*(SampleEnd-SampleStart);
	n*=((float)TrackBarQuality->Position/100.0f);

	return (int)n/8;
}



void __fastcall TFormImportWAV::DrawSample(void)
{
	TCanvas *c;
	int i,w,h,size,xs,xe;
	float n,off,step;

	c=PaintBoxSample->Canvas;
	w=PaintBoxSample->Width;
	h=PaintBoxSample->Height;

	xs=((float)(w-2)*SampleStart)+1;
	xe=((float)(w-2)*SampleEnd  )+1;

	if(xs>w-2) xs=w-2;
	if(xe>w-2) xe=w-2;

	c->Lock();
	c->Pen->Width=1;
	c->Brush->Color=clBlack;

	if(SampleData)
	{
		c->FillRect(TRect(0  ,0,1,h));
		c->FillRect(TRect(w-1,0,w,h));

		off=0;
		step=(float)SampleSize/(float)(w-2);

		for(i=1;i<w-1;++i)
		{
			c->Pen->Color=(i>=xs&&i<xe)?clLime:clGreen;

			n=(float)SampleData[(int)off]/65536.0f*SampleVolume;

			if(n<0) n=0;
			if(n>1) n=1;

			n=(float)(h-2)*n;

			c->FillRect(TRect(i,0,i+1,h));
			c->PenPos=TPoint(i,h/2-n);
			c->LineTo(i,h/2+n);

			if(i==xs)
			{
				c->Pen->Color=clWhite;
				c->PenPos=TPoint(xs,0);
				c->LineTo(xs,h);
			}

			if(i==xe)
			{
				c->Pen->Color=clWhite;
				c->PenPos=TPoint(xe,0);
				c->LineTo(xe,h);
			}

			off+=step;
		}
	}
	else
	{
		c->FillRect(TRect(0,0,w,h));
	}

	c->Unlock();

	size=CalcSampleSize();

	LabelSampleSize->Caption="Sample size: "+IntToStr(size)+" bytes"+(size<MAX_SAMPLE_SIZE?"":" (too large)");
}



void __fastcall TFormImportWAV::ConvertSample(void)
{
	int i,j,n,pp,pd,id,size,start,end;
	AnsiString name;
	short int *sample;
	float acc,smp,qf,cnt,step,pitch;

	if(!FormMain->GroupBoxSamples->Visible) return;

	id=FormMain->ListBoxSamples->ItemIndex;

	if(id<0||!SampleData||!SampleSize||CalcSampleSize()<=0||CalcSampleSize()>MAX_SAMPLE_SIZE) return;

	qf  =((float)TrackBarQuality->Position/100.0f);
	size=((float)SampleSize*qf);

	sample=(short int*)malloc(size*sizeof(short int));
	pp=0;
	pd=0;
	smp=0;
	cnt=0;
	acc=0;

	while(pp<SampleSize)
	{
		smp+=SampleData[pp++];
		acc+=1.0f;
		cnt+=qf;

		if(cnt>=1.0f)
		{
			if(pd<size)
			{
				sample[pd++]=smp/acc;
				smp=0;
				acc=0;
			}

			cnt-=1.0f;
		}
	}

	size=pd;

	start=(int)((float)size*SampleStart);
	end  =(int)((float)size*SampleEnd);

	pp=start;
	pd=0;
	size=(end-start+7)/8;

	for(i=0;i<size;++i)
	{
		n=0;

		for(j=0;j<8;++j)
		{
			smp=(float)sample[pp++]*SampleVolume;
			n|=((smp<4096.0f?1:0)<<(7-j));
		}

		FormMain->sampleList[id].data[pd++]=n;
	}

	free(sample);

	pitch=3500000.0f/((float)SampleRate*qf);

	if(pitch<=83.0f)
	{
		pitch=1;
	}
	else
	{
		pitch=(pitch-83.0f)/16.0f+1;
		pitch=floor(pitch)+(pitch-floor(pitch)<.5?0:1);
	}

	name=EditSampleFile->Text;
	name=name.SubString(name.LastDelimiter("\\/")+1,name.Length()-name.LastDelimiter("\\/"));
	name=name.SubString(1,name.LastDelimiter(".")-1);
	name=name.SubString(1,127);

	strcpy(FormMain->sampleList[id].name,name.c_str());

	FormMain->sampleList[id].length=pd;
	FormMain->sampleList[id].pitch =(int)pitch;

	FormMain->effectsList[FormMain->ListBoxEffects->ItemIndex].block[FormMain->ListBoxBlocks->ItemIndex].samplePitch=(int)pitch;

	FormMain->UpdateSamplesList(id);
	FormMain->UpdateInfo();
	FormMain->UpdateBlockParams();
}



void __fastcall TFormImportWAV::NewSample(void)
{
	if(SampleData)
	{
		free(SampleData);
		SampleData=NULL;
	}

	SampleSize=0;
	SampleStart=0;
	SampleEnd=1;
	TrackBarVolume->Position=50;
	EditSampleFile->Text="Not loaded";
}



//---------------------------------------------------------------------------
__fastcall TFormImportWAV::TFormImportWAV(TComponent* Owner)
: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormImportWAV::FormCreate(TObject *Sender)
{
	SampleData=NULL;
	NewSample();
}
//---------------------------------------------------------------------------

void __fastcall TFormImportWAV::FormDestroy(TObject *Sender)
{
	if(SampleData) free(SampleData);
}
//---------------------------------------------------------------------------

void __fastcall TFormImportWAV::SpeedButtonLoadWAVClick(TObject *Sender)
{
	if(OpenDialogWAV->Execute())
	{
		if(LoadWAV(OpenDialogWAV->FileName))
		{
			EditSampleFile ->Text    =OpenDialogWAV->FileName;
			TrackBarVolume ->Position=50;
			TrackBarQuality->Position=100;

			DrawSample();
			ConvertSample();
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TFormImportWAV::PaintBoxSamplePaint(TObject *Sender)
{
	DrawSample();
}
//---------------------------------------------------------------------------

void __fastcall TFormImportWAV::PaintBoxSampleMouseMove(TObject *Sender,
TShiftState Shift, int X, int Y)
{
	float sx;

	if(Shift.Contains(ssLeft)||Shift.Contains(ssRight))
	{
		sx=(float)X/(float)PaintBoxSample->Width;

		if(Shift.Contains(ssLeft))  SampleStart=sx;
		if(Shift.Contains(ssRight)) SampleEnd  =sx;

		if(SampleStart<0) SampleStart=0;
		if(SampleStart>1) SampleStart=1;
		if(SampleEnd  <0) SampleEnd  =0;
		if(SampleEnd  >1) SampleEnd  =1;

		if(SampleStart>SampleEnd)
		{
			sx=SampleStart;
			SampleStart=SampleEnd;
			SampleEnd=sx;
		}

		DrawSample();
		ConvertSample();
	}
}
//---------------------------------------------------------------------------

void __fastcall TFormImportWAV::PaintBoxSampleMouseDown(TObject *Sender,
TMouseButton Button, TShiftState Shift, int X, int Y)
{
	PaintBoxSampleMouseMove(Sender,Shift,X,Y);
}
//---------------------------------------------------------------------------

void __fastcall TFormImportWAV::SpeedButtonSelectAllClick(TObject *Sender)
{
	SampleStart=0;
	SampleEnd=1;
	DrawSample();
	ConvertSample();
}
//---------------------------------------------------------------------------

void __fastcall TFormImportWAV::TrackBarVolumeChange(TObject *Sender)
{
	SampleVolume=(float)(100-TrackBarVolume->Position)/50.0f;
	if(SampleVolume>1.0f) SampleVolume*=SampleVolume;
	DrawSample();
	ConvertSample();
}
//---------------------------------------------------------------------------

void __fastcall TFormImportWAV::TrackBarQualityChange(TObject *Sender)
{
	DrawSample();
	ConvertSample();
}
//---------------------------------------------------------------------------

void __fastcall TFormImportWAV::FormClose(TObject *Sender, TCloseAction &Action)
{
	NewSample();
}
//---------------------------------------------------------------------------