//---------------------------------------------------------------------------

#ifndef UnitMainH
#define UnitMainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <Dialogs.hpp>

#include <stdio.h>

#define PLAYER_SIZE		215

#define EFFECTS_MAX		128
#define BLOCKS_MAX		128
#define SAMPLES_MAX		128

struct blockStruct {
	int type;
	int frames;
	int frameLen;
	int tonePitch;
	int tonePitchSlide;
	int noisePitch;
	int noisePitchSlide;
	int duty;
	int dutySlide;

	int sampleNumber;
	int samplePitch;
	int sampleOffset;
};



struct effectStruct {
	blockStruct block[BLOCKS_MAX];
	int blocksCount;
	char name[32];
};



struct sampleStruct {
	char name[128];
	unsigned char data[32768];
	int length;
	int adr;
	int pitch;
};

//---------------------------------------------------------------------------
class TFormMain : public TForm
{
__published:	// IDE-managed Components
	TMainMenu *MainMenu;
	TMenuItem *MFile;
	TMenuItem *MOpenProject;
	TMenuItem *MSaveProject;
	TMenuItem *MClose;
	TMenuItem *N1;
	TGroupBox *GroupBoxEffects;
	TListBox *ListBoxEffects;
	TSpeedButton *SpeedButtonEffectAdd;
	TSpeedButton *SpeedButtonEffectDel;
	TSpeedButton *SpeedButtonEffectClone;
	TSpeedButton *SpeedButtonEffectUp;
	TSpeedButton *SpeedButtonEffectDown;
	TMenuItem *MPlayEffect;
	TMenuItem *MStop;
	TMenuItem *MNew;
	TMenuItem *N2;
	TOpenDialog *OpenDialogProject;
	TSaveDialog *SaveDialogProject;
	TEdit *EditEffectName;
	TMenuItem *MCompile;
	TMenuItem *N3;
	TMenuItem *MPlayBlock;
	TMenuItem *MRandomizeBlock;
	TMenuItem *MMergeProject;
	TMenuItem *N4;
	TGroupBox *GroupBoxBlocks;
	TSpeedButton *SpeedButtonBlockAdd;
	TSpeedButton *SpeedButtonBlockDel;
	TSpeedButton *SpeedButtonBlockClone;
	TSpeedButton *SpeedButtonBlockUp;
	TSpeedButton *SpeedButtonBlockDown;
	TListBox *ListBoxBlocks;
	TGroupBox *GroupBoxInfo;
	TLabel *LabelEffectSize;
	TLabel *LabelDataSize;
	TLabel *LabelEffectsCount;
	TPageControl *PageControlBlockType;
	TTabSheet *TabSheetTone;
	TLabel *Label1;
	TLabel *Label3;
	TLabel *Label5;
	TLabel *Label4;
	TLabel *Label2;
	TLabel *Label6;
	TEdit *EditTonePitch;
	TEdit *EditToneDuty;
	TEdit *EditToneFrames;
	TEdit *EditToneFrameLen;
	TEdit *EditTonePitchSlide;
	TEdit *EditToneDutySlide;
	TTabSheet *TabSheetNoise;
	TLabel *Label7;
	TLabel *Label8;
	TLabel *Label9;
	TLabel *Label10;
	TEdit *EditNoiseFrames;
	TEdit *EditNoiseFrameLen;
	TEdit *EditNoisePitch;
	TEdit *EditNoisePitchSlide;
	TTabSheet *TabSheetSample;
	TLabel *Label14;
	TEdit *EditSamplePitch;
	TTabSheet *TabSheetPause;
	TLabel *Label11;
	TLabel *Label12;
	TEdit *EditPauseFrames;
	TEdit *EditPauseFrameLen;
	TGroupBox *GroupBoxSamples;
	TSpeedButton *SpeedButtonImportSample;
	TSpeedButton *SpeedButtonClearSample;
	TListBox *ListBoxSamples;
	TLabel *LabelSampleSize;
	TLabel *Label13;
	TEdit *EditSampleOffset;
	void __fastcall MCloseClick(TObject *Sender);
	void __fastcall ListBoxEffectsDblClick(TObject *Sender);
	void __fastcall MPlayEffectClick(TObject *Sender);
	void __fastcall MPlayBlockClick(TObject *Sender);
	void __fastcall MStopClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall MNewClick(TObject *Sender);
	void __fastcall SpeedButtonEffectAddClick(TObject *Sender);
	void __fastcall SpeedButtonEffectDelClick(TObject *Sender);
	void __fastcall SpeedButtonEffectUpClick(TObject *Sender);
	void __fastcall SpeedButtonEffectDownClick(TObject *Sender);
	void __fastcall MOpenProjectClick(TObject *Sender);
	void __fastcall MSaveProjectClick(TObject *Sender);
	void __fastcall ListBoxEffectsClick(TObject *Sender);
	void __fastcall ListBoxEffectsKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
	void __fastcall EditEffectNameChange(TObject *Sender);
	void __fastcall SpeedButtonEffectCloneClick(TObject *Sender);
	void __fastcall MCompileClick(TObject *Sender);
	void __fastcall SpeedButtonBlockAddClick(TObject *Sender);
	void __fastcall ListBoxBlocksClick(TObject *Sender);
	void __fastcall ListBoxBlocksKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
	void __fastcall PageControlBlockTypeChange(TObject *Sender);
	void __fastcall SpeedButtonBlockDelClick(TObject *Sender);
	void __fastcall SpeedButtonBlockCloneClick(TObject *Sender);
	void __fastcall SpeedButtonBlockUpClick(TObject *Sender);
	void __fastcall SpeedButtonBlockDownClick(TObject *Sender);
	void __fastcall EditToneFramesKeyPress(TObject *Sender, char &Key);
	void __fastcall EditToneFramesChange(TObject *Sender);
	void __fastcall EditToneFramesExit(TObject *Sender);
	void __fastcall EditToneFrameLenChange(TObject *Sender);
	void __fastcall EditToneFrameLenExit(TObject *Sender);
	void __fastcall EditTonePitchChange(TObject *Sender);
	void __fastcall EditTonePitchExit(TObject *Sender);
	void __fastcall EditTonePitchSlideChange(TObject *Sender);
	void __fastcall EditTonePitchSlideExit(TObject *Sender);
	void __fastcall EditNoisePitchChange(TObject *Sender);
	void __fastcall EditNoisePitchExit(TObject *Sender);
	void __fastcall EditNoisePitchSlideChange(TObject *Sender);
	void __fastcall EditNoisePitchSlideExit(TObject *Sender);
	void __fastcall EditToneDutyChange(TObject *Sender);
	void __fastcall EditToneDutyExit(TObject *Sender);
	void __fastcall EditToneDutySlideChange(TObject *Sender);
	void __fastcall EditToneDutySlideExit(TObject *Sender);
	void __fastcall MRandomizeBlockClick(TObject *Sender);
	void __fastcall ListBoxBlocksDblClick(TObject *Sender);
	void __fastcall MMergeProjectClick(TObject *Sender);
	void __fastcall ListBoxSamplesClick(TObject *Sender);
	void __fastcall SpeedButtonClearSampleClick(TObject *Sender);
	void __fastcall SpeedButtonImportSampleClick(TObject *Sender);
	void __fastcall FormResize(TObject *Sender);
	void __fastcall EditSamplePitchChange(TObject *Sender);
	void __fastcall EditSamplePitchExit(TObject *Sender);
	void __fastcall EditSampleOffsetChange(TObject *Sender);
	void __fastcall EditSampleOffsetExit(TObject *Sender);
	void __fastcall ListBoxSamplesDblClick(TObject *Sender);
private:	// User declarations
public:		// User declarations
	__fastcall TFormMain(TComponent* Owner);
	void __fastcall GenerateSound(int,int);
	void __fastcall ClearBlock(int,int);
	void __fastcall ClearEffect(int);
	void __fastcall ClearAllEffects(void);
	void __fastcall ClearSample(int);
	void __fastcall ClearAllSamples(void);
	void __fastcall UpdateEffectsList(int);
	void __fastcall UpdateEffectName(void);
	void __fastcall UpdateBlocksList(int);
	void __fastcall UpdateBlockParams(void);
	void __fastcall UpdateBlockListInfo(void);
	void __fastcall UpdateSamplesList(int cur);
	void __fastcall UpdateInfo(void);
	void __fastcall UpdateAddDel(void);
	void __fastcall UpdateAll(int,int);
	int __fastcall CalcEffectSize(int);
	int __fastcall CalcDataSize(void);
	AnsiString __fastcall GetBlockInfo(int,int);
	void __fastcall SaveCodeToTap(FILE*,int,int);
	void __fastcall CompileAssembly(AnsiString,int,bool);
	void __fastcall CompileBinary(AnsiString,int,bool);
	void __fastcall CompileTap(AnsiString,int,bool,bool);
	void __fastcall PlayerReloc(int,int);
	int __fastcall CompileMemBlock(int,int,int);
	int __fastcall CompileSamplesMem(int);
	int __fastcall CompileMem(int,bool,int);
	int __fastcall LoadProject(AnsiString,void*);
	bool __fastcall SaveProject(AnsiString);
	void __fastcall NewProject(void);
	void __fastcall CheckSamplesUse(bool*);

	effectStruct effectsList[EFFECTS_MAX];
	sampleStruct sampleList[SAMPLES_MAX];

	int effectsCount;
	int effectsAddCount;

	short *waveTest;
	int waveTestBufSize;
	int waveTestSize;

	unsigned char mem[65536];

	bool stateSound;
	bool stateRun;
};
//---------------------------------------------------------------------------
extern PACKAGE TFormMain *FormMain;
//---------------------------------------------------------------------------
#endif
