#include <mmsystem.h>


struct {
	HWAVEOUT device;
	WAVEHDR header;
} WAVE;



void SoundInit(void)
{
	WAVE.device=NULL;
}



void SoundStop(void)
{
	if(WAVE.device)
	{
		waveOutReset(WAVE.device);
		waveOutUnprepareHeader(WAVE.device,&WAVE.header,sizeof(WAVEHDR));
		waveOutClose(WAVE.device);
		WAVE.device=NULL;
	}
}



bool SoundPlay(HWND sWnd,short *data,int size)
{
    WAVEFORMATEX format;
	
	SoundStop();

    format.nSamplesPerSec=44100;
    format.wBitsPerSample=16;
    format.nChannels=1;
    format.cbSize=0;
    format.wFormatTag=WAVE_FORMAT_PCM;
    format.nBlockAlign=(format.wBitsPerSample*format.nChannels)>>3;
    format.nAvgBytesPerSec=format.nBlockAlign*format.nSamplesPerSec;

    if(waveOutOpen(&WAVE.device,WAVE_MAPPER,&format,0,0,CALLBACK_NULL)!=MMSYSERR_NOERROR) return false;

	ZeroMemory(&WAVE.header,sizeof(WAVEHDR));

	WAVE.header.dwBufferLength=size;
	WAVE.header.lpData=(char*)data;

	waveOutPrepareHeader(WAVE.device,&WAVE.header,sizeof(WAVEHDR));
	waveOutWrite(WAVE.device,&WAVE.header,sizeof(WAVEHDR));
	
    return true;
}